﻿//=============================================================================
// CommonQuest.js
//=============================================================================

var Imported = Imported || {};
Imported.PreOrderQuestContent = true;

/*:
 * @plugindesc コモン クエスト一覧を表示するスクリプト
 * 
 * @help
 * プラグインコマンド:
 *
 *   CommonQuest list
 *     コモン クエスト一覧を表示する。
 *
 *   CommonQuest refresh
 *     コモン クエスト一覧を更新する。
 */

(function ()
{
    // プラグイン コマンド
    var _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
    Game_Interpreter.prototype.pluginCommand = function (command, args)
    {
        _Game_Interpreter_pluginCommand.call(this, command, args);

        if (command === 'CommonQuest')
        {
            switch (args[0])
            {
                case 'show':
                    SceneManager.push(Scene_CommonQuest);
                    break;

                case 'hide':
                    SceneManager.pop();
                    break;

                case 'refresh':
                    $gameSystem.SetShouldCommonQuestListRefresh(true);
                    break;
            }
        }
    };

    //-----------------------------------------------------------------------------
    // Scene_CommonQuest
    //
    function Scene_CommonQuest()
    {
        this.initialize.apply(this, arguments);
    }

    Scene_CommonQuest.prototype = Object.create(Scene_MenuBase.prototype);
    Scene_CommonQuest.prototype.constructor = Scene_CommonQuest;

    // 作成
    Scene_CommonQuest.prototype.create = function ()
    {
        Scene_MenuBase.prototype.create.call(this);

        this.createQuestListWindow();
        this.createQuestContentWindow();
    };

    // クエスト一覧ウィンドウの作成
    Scene_CommonQuest.prototype.createQuestListWindow = function ()
    {
        var list = new Array(5);

        for (var i = 0; i < 5; ++i)
        {
            list[i] = $gameVariables.value(116 + i);
        }

        this._questListWindow = new QuestListWindow(list, true);
        this._questListWindow.setHandler('ok', this.chooseQuest.bind(this));
        this._questListWindow.setHandler('cancel', this.popScene.bind(this));

        this._questListWindow.canPlayOK = true;

        this.addWindow(this._questListWindow);

        // 選択肢の値
        $gameVariables.setValue(2, -1);
    };

    // クエスト内容ウィンドウの作成
    Scene_CommonQuest.prototype.createQuestContentWindow = function ()
    {
        this._questContentWindow = new QuestContentWindow(this._questListWindow);
        this.addWindow(this._questContentWindow);

        this._questListWindow.contentWindow = this._questContentWindow;
    };

    // クエストを選択する
    Scene_CommonQuest.prototype.chooseQuest = function ()
    {
        var data = this._questListWindow.data;
        var index = this._questListWindow.index();

        // 選択肢の値
        $gameVariables.setValue(2, data[index].no);

        $gameVariables.setValue(3, data[index].title);

        $gameVariables.setValue(4, index);

        this.popScene();
    };
})();
